let g:audio_record_file = -1
let g:audio_record_tmp_file = -1
let g:audio_record_cmd = expand('~/record.sh')
let g:audio_transcribe_cmd = expand('~/transcribe.sh')
let g:audio_record_pid = -1
let g:audio_record_transcript_file = -1

function! ToggleVoiceNote()
  if g:audio_record_pid != -1
	  call StopRecording()
	  call TranscribeLastRecording()
  else
	  call StartRecording()
  endif
endfunction

function! StartRecording()
  if g:audio_record_pid != -1
    echo "Recording already in progress (PID " . g:audio_record_pid . ")"
    return
  endif

  " Temp file where record.sh will write the WAV path
  let l:temp_file = tempname()

  " Run record.sh; its stdout (the wav path) goes to temp_file.
  " Then echo the background PID.
  let l:cmd = printf('%s > %s 2>/dev/null & echo $!', shellescape(g:audio_record_cmd), shellescape(l:temp_file))

  let l:pid = str2nr(system(l:cmd))

  if l:pid <= 0
    echoerr "Failed to start recording"
    return
  endif

  " Read the file path written by record.sh
  let g:audio_record_file = trim(system('cat ' . shellescape(l:temp_file)))
  let g:audio_record_tmp_file = l:temp_file
  let g:audio_record_pid = l:pid

  echo "Recording started (PID " . g:audio_record_pid . ") -> " . g:audio_record_file
endfunction

function! StopRecording()
  if g:audio_record_pid == -1
    echo "No recording in progress"
    return
  endif

  call system('kill ' . g:audio_record_pid)

  if g:audio_record_tmp_file != -1
    call system('rm -f ' . shellescape(g:audio_record_tmp_file))
    let g:audio_record_tmp_file = -1
  endif

  let g:audio_record_pid = -1
  let g:audio_record_transcript_file = -1

  echo "Recording stopped."
endfunction


function! TranscribeLastRecording()
  if g:audio_record_file == -1
    echo "No recent recording"
    return
  endif

  let l:cmd = printf('%s %s', shellescape(g:audio_transcribe_cmd), shellescape(g:audio_record_file))

  " transcribe.sh echoes the .txt path
  let l:transcription_file = trim(system(l:cmd))

  if v:shell_error != 0 || empty(l:transcription_file)
    echoerr "Transcription failed"
    return
  endif

  let g:audio_record_file = -1
  execute 'tabe' fnameescape(l:transcription_file)
endfunction



" BINDINGS

command! VoiceNote call ToggleVoiceNote()

nnoremap <Leader>vn :VoiceNote<CR>
